"""
This is the example for the yolov5 example.
"""
import cv2
import numpy as np


from common import constants, kdp_wrapper
from common.pre_post_process.yolo.yolo_postprocess import yolo_postprocess_

# image input resolution, for HW preprocess, image size should be larger than model input size
image_source_w = 640
image_source_h = 480


# model information

model_file = "../input_models/KL520/models_520_480x256_mask_3types.nef"
# model_file = "../input_models/KL520/models_520_480x256.nef"
model_id = constants.ModelType.CUSTOMER.value

model_input_col = 480
model_input_row = 256

# the parameters for postprocess
anchor_path = './common/pre_post_process/yolo/models/anchors_v3.txt'
# class_path = './common/class_lists/mask'
class_path = './common/class_lists/coco_name_lists'


# crop parameter
crop_top = 0
crop_bottom = 16
crop_left = 0
crop_right = 0



def post_handler(dev_idx, raw_res, captured_frames_path):
    captured_frames = captured_frames_path

    # the parameters for postprocess
    model_input_shape = (model_input_col, model_input_row)
    score_thres       = 0.3
    nms_thres         = 0.5
    keep_aspect_ratio = True
    original_height =  image_source_h - crop_top - crop_bottom
    original_width = image_source_w - crop_left - crop_right
    is_v5 = True
    sigmoid_in_post_v5 = True


    raw_res.sort(key=lambda x: x.size)

    det_res = yolo_postprocess_(raw_res, anchor_path, class_path, original_height, original_width, model_input_shape,
                              score_thres, nms_thres, keep_aspect_ratio, is_v5, sigmoid_in_post_v5)

    kdp_wrapper.draw_capture_result(dev_idx, det_res, captured_frames, "yolo", xywh=False)

    return 0


def user_test_single_dme(dev_idx, loop):
    """Test single DME."""
    # As sigmoid is not supported by KL520 fw, the sigmoid nodes have been cut,
    # and NEF does not include sigmoid nodes.
    image_cfg = (constants.IMAGE_FORMAT_RAW_OUTPUT | constants.NPU_FORMAT_RGB565 | constants.IMAGE_FORMAT_SUB128)

    #for model 480x256, crop image 640x480 into 640x464 to keep the pad value smaller than 127
    crop_box=(crop_top, image_source_h-crop_bottom, crop_left, image_source_w-crop_right)

    # Load model into Kneron device.
    dme_config = kdp_wrapper.init_dme_config(model_id, 3, image_cfg, image_col=image_source_w, image_row=image_source_h,image_ch = 2,\
    crop_box=crop_box)

    ret = kdp_wrapper.dme_load_model(dev_idx, model_file, dme_config)
    if ret == -1:
        return -1

    app_id = 0 # if app_id is 0, output raw data for kdp_wrapper.kdp_dme_inference

    # Setup video capture device.
    image_size = image_source_w * image_source_h * 2 # rgb565
    frames = []
    capture = kdp_wrapper.setup_capture(0, image_source_w, image_source_h)
    if capture is None:
        return -1

    # Send 1 image to the DME image buffers.
    ssid = kdp_wrapper.dme_fill_buffer(dev_idx, capture, image_size, frames, image_source_w, image_source_h)
    if ssid == -1:
        print("dme_fill_buffer fail!")
        return -1

    return kdp_wrapper.dme_pipeline_inference(
        dev_idx, app_id, loop, image_size, capture, ssid, frames, post_handler, image_source_w, image_source_h)

def user_test(dev_idx, _user_id):
    # dme test
    ret = user_test_single_dme(dev_idx, 0)
    kdp_wrapper.end_det(dev_idx)
    return ret


